/** = https://github.com/dmytrov/IntelPWMControl */

#include <windows.h>
#include <objbase.h>
#include <stdio.h>
#include <algorithm>

#undef NDEBUG
#include <assert.h>

namespace {
	bool done = false;
}

struct ICUIPower : public IUnknown
{
  virtual HRESULT STDMETHODCALLTYPE IsSupported(LPBOOL pSupported);
  virtual HRESULT STDMETHODCALLTYPE dummy1();
  virtual HRESULT STDMETHODCALLTYPE dummy2();
  virtual HRESULT STDMETHODCALLTYPE dummy3();
  virtual HRESULT STDMETHODCALLTYPE dummy4();
  virtual HRESULT STDMETHODCALLTYPE GetPWMFrequency(LPUINT puiInverterType, LPDWORD pdwPWMFreq, LPDWORD pdwErrorCodes);
  virtual HRESULT STDMETHODCALLTYPE SetPWMFrequency(UINT uiInverterType, DWORD dwPWMFreq, LPDWORD pdwErrorCodes);
};

BOOL WINAPI ConsoleHandler(DWORD dwType)
{
    switch(dwType) {
    case CTRL_CLOSE_EVENT:
    case CTRL_LOGOFF_EVENT:
    case CTRL_SHUTDOWN_EVENT:

	  done = true;//signal the main thread to terminate

	  //Returning would make the process exit!
      //We just make the handler sleep until the main thread exits,
      //or until the maximum execution time for this handler is reached.
	  Sleep(5000);

      return TRUE;
    default:
      break;
    }
    return FALSE;
}



int WINAPI WinMain (HINSTANCE hThisInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR lpszArgument,
                     int nCmdShow)
{
  unsigned int targetPWMFreq = 500;
  if (lpszArgument) {
    sscanf(lpszArgument, "%u", &targetPWMFreq);
  }

  targetPWMFreq = std::max(targetPWMFreq, 220u);
  targetPWMFreq = std::min(targetPWMFreq, 2000u);
  assert(SUCCEEDED(CoInitialize(0)));
  CLSID clsid = { 0xC332C124, 0x340D, 0x4430, { 0xAA, 0x0D, 0xC7, 0x56, 0x02, 0x87, 0x6F, 0xCC } };
  IID IID_ICUIPower = { 0x299D88F9, 0x2CBD, 0x4225, { 0xBF, 0x19, 0xFC, 0xD1, 0x64, 0xC5, 0x4C, 0x3F } };
  IUnknown *pUnknown;
  assert(SUCCEEDED(CoCreateInstance(clsid, 0, CLSCTX_LOCAL_SERVER, IID_IUnknown, (void**)&pUnknown)));
  ICUIPower *pCUIPower;
  assert(SUCCEEDED(pUnknown->QueryInterface(IID_ICUIPower, (void**)&pCUIPower)));
  while (!done)
  {
    UINT uiInverterType = 0;
    DWORD dwPWMFreq = 0,
          dwErrorCodes = 0;
	try
	{
		pCUIPower->GetPWMFrequency(&uiInverterType, &dwPWMFreq, &dwErrorCodes);
		if (dwPWMFreq != targetPWMFreq)
		{
			dwPWMFreq = targetPWMFreq;
			pCUIPower->SetPWMFrequency(uiInverterType, dwPWMFreq, &dwErrorCodes);
		}
	}
	catch (...)
	{
		// Nothing here
	}

	for (int i=0; i<10; i++) {
		Sleep(2000);
    	if (done) {
            break;
        }
	}
  }
  pCUIPower->Release();
  pUnknown->Release();
  CoUninitialize();
  return 0;
}
