//---------------------------------------------------------------------------


#pragma hdrstop

#include "Settings.h"
#include "common\KeybKeys.h"
#include <algorithm>
#include <fstream>
#include <json/json.h>

//---------------------------------------------------------------------------

#pragma package(smart_init)

Settings appSettings;

inline void strncpyz(char* dst, const char* src, int dstsize) {
	strncpy(dst, src, dstsize);
	dst[dstsize-1] = '\0';
}

Settings::_gui::_gui(void):
	scalingPct(SCALING_DEF),
	showTrayIcon(true)
{
}

void Settings::_gui::fromJson(const Json::Value &jv)
{
	if (jv.type() != Json::objectValue)
		return;
	jv.getIntInRange("scalingPct", scalingPct, SCALING_MIN, SCALING_MAX);
	jv.getBool("showTrayIcon", showTrayIcon);
}

void Settings::_gui::toJson(Json::Value &jv) const
{
	jv = Json::Value(Json::objectValue);
	jv["scalingPct"] = scalingPct;
	jv["showTrayIcon"] = showTrayIcon;
}

void Settings::SetDefault(void)
{
	frmMain.iWidth = 562;
	frmMain.iHeight = 320;
	frmMain.iPosX = 30;
	frmMain.iPosY = 30;
	frmMain.bWindowMaximized = false;
	frmMain.bAlwaysOnTop = false;
	frmMain.bExitFullScreenOnStop = true;
	frmMain.controlPanelPosition = _frmMain::CONTROL_PANEL_TOP;
	frmMain.ignoreMouseMovementInFullScreenPlayback = false;

	Logging.bLogToFile = false;
	Logging.bFlush = false;
	Logging.iMaxFileSize = Settings::_Logging::DEF_MAX_FILE_SIZE;
	Logging.iMaxUiLogLines = 5000;

	{
		hotKeyConf.clear();
		struct HotKeyConf hk;
		struct Action action;

		hk.keyCode = "VK_SPACE";
		hk.modifiers = 0;
		action.type = Action::TYPE_PLAY_PAUSE;
		hk.action = action;
		hotKeyConf.push_back(hk);

		hk.keyCode = "VK_RETURN";
		hk.modifiers = 0;
		action.type = Action::TYPE_PLAY_STOP;
		hk.action = action;
		hotKeyConf.push_back(hk);

		hk.keyCode = "VK_LEFT";
		hk.modifiers = 0;
		action.type = Action::TYPE_SEEK_M3;
		hk.action = action;
		hotKeyConf.push_back(hk);

		hk.keyCode = "VK_RIGHT";
		hk.modifiers = 0;
		action.type = Action::TYPE_SEEK_P3;
		hk.action = action;
		hotKeyConf.push_back(hk);

		hk.keyCode = "VK_DOWN";
		hk.modifiers = 0;
		action.type = Action::TYPE_SEEK_M60;
		hk.action = action;
		hotKeyConf.push_back(hk);

		hk.keyCode = "VK_UP";
		hk.modifiers = 0;
		action.type = Action::TYPE_SEEK_P60;
		hk.action = action;
		hotKeyConf.push_back(hk);

		hk.keyCode = "F key";
		hk.modifiers = 0;
		action.type = Action::TYPE_TOGGLE_FULLSCREEN;
		hk.action = action;
		hotKeyConf.push_back(hk);

		hk.keyCode = "I key";
		hk.modifiers = 0;
		action.type = Action::TYPE_SHOW_FILE_INFO;
		hk.action = action;
		hotKeyConf.push_back(hk);

		hk.keyCode = "M key";
		hk.modifiers = 0;
		action.type = Action::TYPE_MINIMIZE;
		hk.action = action;
		hotKeyConf.push_back(hk);

		hk.keyCode = "N key";
		hk.modifiers = 0;
		action.type = Action::TYPE_SKIP;
		hk.action = action;
		hotKeyConf.push_back(hk);

		hk.keyCode = "VK_NEXT";
		hk.modifiers = 0;
		action.type = Action::TYPE_SKIP;
		hk.action = action;
		hotKeyConf.push_back(hk);

		hk.keyCode = "P key";
		hk.modifiers = 0;
		action.type = Action::TYPE_PREV;
		hk.action = action;
		hotKeyConf.push_back(hk);

		hk.keyCode = "VK_PRIOR";
		hk.modifiers = 0;
		action.type = Action::TYPE_PREV;
		hk.action = action;
		hotKeyConf.push_back(hk);

		hk.keyCode = "O key";
		hk.modifiers = 0;
		action.type = Action::TYPE_TOGGLE_OSD;
		hk.action = action;
		hotKeyConf.push_back(hk);

		hk.keyCode = "S key";
		hk.modifiers = 0;
		action.type = Action::TYPE_TOGGLE_SUB_VISIBILITY;
		hk.action = action;
		hotKeyConf.push_back(hk);

		hk.keyCode = "D key";
		hk.modifiers = 0;
		action.type = Action::TYPE_DELETE_FILE;
		hk.action = action;
		hotKeyConf.push_back(hk);

		hk.keyCode = "L key";
		hk.modifiers = 0;
		action.type = Action::TYPE_SHOW_LOG;
		hk.action = action;
		hotKeyConf.push_back(hk);

		hk.keyCode = "VK_ESCAPE";
		hk.modifiers = 0;
		action.type = Action::TYPE_EXIT_FS_EXIT;
		hk.action = action;
		hotKeyConf.push_back(hk);

		for (std::list<HotKeyConf>::iterator iter = hotKeyConf.begin(); iter != hotKeyConf.end(); ++iter)
		{
            HotKeyConf &cfg = *iter;
			int id = vkey_find(cfg.keyCode.c_str());
			if (id >= 0)
			{
				cfg.vkCode = vkey_list[id].vkey;
			}
			else
			{
				cfg.vkCode = -1;
			}
		}
	}

	hiddenPlaylistsModified = false;
}

int Settings::Read(AnsiString asFileName)
{
	Json::Value root;   // will contains the root value after parsing.
	Json::Reader reader;

    SetDefault();

	try
	{
		std::ifstream ifs(asFileName.c_str());
		std::string strConfig((std::istreambuf_iterator<char>(ifs)), std::istreambuf_iterator<char>());
		ifs.close();
		bool parsingSuccessful = reader.parse( strConfig, root );
		if ( !parsingSuccessful )
		{
			return 2;
		}
	}
	catch(...)
	{
		return 1;
	}

	int maxX = GetSystemMetrics(SM_CXSCREEN);
	/** \todo Ugly fixed taskbar margin */
	int maxY = GetSystemMetrics(SM_CYSCREEN) - 32;

	gui.fromJson(root["gui"]);

	const Json::Value &frmMainJson = root["frmMain"];
	frmMain.iWidth = frmMainJson.get("AppWidth", 350).asInt();
	frmMain.iHeight = frmMainJson.get("AppHeight", 300).asInt();
	if (frmMain.iWidth < 250 || frmMain.iWidth > maxX + 20)
	{
		frmMain.iWidth = 250;
	}
	if (frmMain.iHeight < 200 || frmMain.iHeight > maxY + 20)
	{
		frmMain.iHeight = 200;
	}
	frmMain.iPosX = frmMainJson.get("AppPositionX", 30).asInt();
	frmMain.iPosY = frmMainJson.get("AppPositionY", 30).asInt();
	if (frmMain.iPosX < 0)
		frmMain.iPosX = 0;
	if (frmMain.iPosY < 0)
		frmMain.iPosY = 0;
	if (frmMain.iPosX + frmMain.iWidth > maxX)
		frmMain.iPosX = maxX - frmMain.iWidth;
	if (frmMain.iPosY + frmMain.iHeight > maxY)
		frmMain.iPosY = maxY - frmMain.iHeight;
	frmMain.bWindowMaximized = frmMainJson.get("Maximized", false).asBool();
	frmMain.bAlwaysOnTop = frmMainJson.get("AlwaysOnTop", false).asBool();
	frmMain.bExitFullScreenOnStop = frmMainJson.get("ExitFullScreenOnStop", frmMain.bExitFullScreenOnStop).asBool();
	frmMain.controlPanelPosition = static_cast<_frmMain::ControlPanelPosition>(frmMainJson.get("ControlPanelPosition", frmMain.controlPanelPosition).asInt());
	frmMainJson.getBool("IgnoreMouseMovementInFullScreenPlayback", frmMain.ignoreMouseMovementInFullScreenPlayback);

	const Json::Value &LoggingJson = root["Logging"];
	Logging.bLogToFile = LoggingJson.get("LogToFile", false).asBool();
	Logging.bFlush = LoggingJson.get("Flush", Logging.bFlush).asBool();
	Logging.iMaxFileSize = LoggingJson.get("MaxFileSize", Logging.iMaxFileSize).asInt();
	if (Logging.iMaxFileSize < Settings::_Logging::MIN_MAX_FILE_SIZE || Logging.iMaxFileSize > Settings::_Logging::MIN_MAX_FILE_SIZE)
	{
		Logging.iMaxFileSize = Settings::_Logging::DEF_MAX_FILE_SIZE;
	}
	Logging.iMaxUiLogLines = LoggingJson.get("MaxUiLogLines", 5000).asInt();

	{
		const Json::Value &jv = root["Mplayer"];
		Mplayer.softVolMax = jv.get("SoftVolMax", Mplayer.softVolMax).asInt();
		if (Mplayer.softVolMax < 50 || Mplayer.softVolMax > _Mplayer::SOFTVOL_MAX_LIMIT)
		{
			Mplayer.softVolMax = _Mplayer::SOFTVOL_MAX_DEF;
		}
		Mplayer.softVolLevel = jv.get("SoftVolLevel", Mplayer.softVolLevel).asInt();
		if (Mplayer.softVolLevel < 0 || Mplayer.softVolLevel > Mplayer.softVolMax)
			Mplayer.softVolLevel = 100;
		jv.getInt("OsdLevel", Mplayer.osdLevel);
		if (Mplayer.osdLevel < _Mplayer::OSD_LEVEL_MIN || Mplayer.osdLevel > _Mplayer::OSD_LEVEL_MAX)
			Mplayer.osdLevel = _Mplayer::OSD_LEVEL_DEFAULT;
		jv.getBool("SubVisibility", Mplayer.subVisibility);
		jv.getBool("ShowFileNameOnPlayStart", Mplayer.showFileNameOnPlayStart);
		jv.getBool("UseSeparateVolumeForEachFile", Mplayer.useSeparateVolumeForEachFile);
		jv.getBool("ShowPropertyEditor", Mplayer.showPropertyEditor);
	}

	{
		const Json::Value &jv = root["MediaBrowser"];
		jv.getAString("LastPlaylist", mediaBrowser.asLastPlaylist);
	}

	{
		const Json::Value &hotkeyConfJson = root["hotkeyConf"];
		if (hotkeyConfJson.type() == Json::arrayValue)
		{
			hotKeyConf.resize(hotkeyConfJson.size());
			std::list<HotKeyConf>::iterator iter = hotKeyConf.begin();

			for (unsigned int i=0; i<hotkeyConfJson.size(); i++)
			{
				const Json::Value &hotkeyJson = hotkeyConfJson[i];
				class HotKeyConf &cfg = *iter++;
				if (hotkeyJson.type() == Json::objectValue)
				{
					cfg.keyCode = hotkeyJson.get("keyCode", cfg.keyCode.c_str()).asString().c_str();
					int id = vkey_find(cfg.keyCode.c_str());
					if (id >= 0)
					{
						cfg.vkCode = vkey_list[id].vkey;
					}
					else
					{
						cfg.vkCode = -1;
					}
					cfg.modifiers = hotkeyJson.get("modifiers", cfg.modifiers).asInt();
					cfg.global = hotkeyJson.get("global", cfg.global).asBool();
					const Json::Value &action = hotkeyJson["action"];
					cfg.action.type = static_cast<Action::Type>(action.get("type", cfg.action.type).asInt());
					cfg.action.id = action.get("id", cfg.action.id).asInt();
					action.getAString("file", cfg.action.file);
				}
			}
		}
	}

	{
		const Json::Value &jv = root["hiddenPlaylists"];
		hiddenPlaylists.clear();
		if (jv.type() == Json::arrayValue)
		{
			for (unsigned int i=0; i<jv.size(); i++)
			{
				AnsiString name = jv[i].asAString();
				hiddenPlaylists.insert(name);
			}
		}
	}

	mruLua.LoadFrom(root["MRULua"]);

	return 0;
}

int Settings::Write(AnsiString asFileName)
{
	Json::Value root;
	Json::StyledWriter writer("\t");

    gui.toJson(root["gui"]);

	{
		Json::Value &jv = root["frmMain"];
		jv["AppWidth"] = frmMain.iWidth;
		jv["AppHeight"] = frmMain.iHeight;
		jv["AppPositionX"] = frmMain.iPosX;
		jv["AppPositionY"] = frmMain.iPosY;
		jv["Maximized"] = frmMain.bWindowMaximized;
		jv["AlwaysOnTop"] = frmMain.bAlwaysOnTop;
		jv["ExitFullScreenOnStop"] = frmMain.bExitFullScreenOnStop;
		jv["ControlPanelPosition"] = frmMain.controlPanelPosition;
		jv["IgnoreMouseMovementInFullScreenPlayback"] = frmMain.ignoreMouseMovementInFullScreenPlayback;
	}

	{
		Json::Value &jv = root["Logging"];
		jv["LogToFile"] = Logging.bLogToFile;
		jv["Flush"] = Logging.bFlush;
		jv["MaxFileSize"] = Logging.iMaxFileSize;
		jv["MaxUiLogLines"] = Logging.iMaxUiLogLines;
	}

	{
		Json::Value &jv = root["Mplayer"];
		jv["SoftVolMax"] =  Mplayer.softVolMax;
		jv["SoftVolLevel"] = Mplayer.softVolLevel;
		jv["OsdLevel"] = Mplayer.osdLevel;
		jv["SubVisibility"] = Mplayer.subVisibility;
		jv["ShowFileNameOnPlayStart"] = Mplayer.showFileNameOnPlayStart;
		jv["UseSeparateVolumeForEachFile"] = Mplayer.useSeparateVolumeForEachFile;
		jv["ShowPropertyEditor"] = Mplayer.showPropertyEditor;
	}

	{
		Json::Value &jv = root["MediaBrowser"];
		jv["LastPlaylist"] = mediaBrowser.asLastPlaylist;
	}

	{
		int i = 0;
		std::list<HotKeyConf>::iterator iter;
		for (iter = hotKeyConf.begin(); iter != hotKeyConf.end(); ++iter)
		{
			struct HotKeyConf &cfg = *iter;
			Json::Value &cfgJson = root["hotkeyConf"][i++];
			cfgJson["keyCode"] = cfg.keyCode.c_str();
			cfgJson["modifiers"] = cfg.modifiers;
			cfgJson["global"] = cfg.global;
			cfgJson["action"]["type"] = cfg.action.type;
			cfgJson["action"]["id"] = cfg.action.id;
			cfgJson["action"]["file"] = cfg.action.file;
		}
	}

	{
		Json::Value &jv = root["hiddenPlaylists"];
        jv.resize(0);
		for (std::set<AnsiString>::iterator iter = hiddenPlaylists.begin(); iter != hiddenPlaylists.end(); ++iter)
		{
        	jv.append(*iter);
		}
	}

	mruLua.SaveTo(root["MRULua"]);

	std::string outputConfig = writer.write( root );

	try
	{
		std::ofstream ofs(asFileName.c_str());
		ofs << outputConfig;
		ofs.close();
	}
	catch(...)
	{
    	return 1;
	}

	return 0;
}


